/*======================================================================*/
/*                TITLE:          DEFS.H                                */
/*                Function:       Globals                               */
/*                                                                      */
/*                First Edit:     06/07/91                              */
/*                Programmer:     Andrew J. Burgess                     */
/*                                                                      */
/*                 COPYRIGHT 1991 ATARI GAMES CORP.                     */
/*       UNATHORIZED REPRODUCTION, ADAPTATION, DISTRIBUTION,            */
/*       PERFORMANCE OR DISPLAY OF THIS COMPUTER PROGRAM OR             */
/*     THE ASSOCIATED AUDIOVISUAL WORK IS STRICTLY PROHIBITED.          */
/*                         ALL RIGHTS RESERVED.                         */
/*                                                                      */
/*----------------------------------------------------------------------*/


/*======================================================================*/
/*                        DEFINES                                       */
/*======================================================================*/
#define	SUCCESS	0
#define	WARN	1
#define	ERROR	2
#define	INFO	3
#define	FATAL	4

#define	TRACE		0

#define	FALSE		0
#define	TRUE		1

#define	NO			0
#define	YES			1

#define	OFF			0
#define	ON			1

#define	EMPTY		(-1)

#define	HORIZONTAL	0
#define	VERTICAL	1

#define	MAXLEN		256
#define	NAMELEN		64

#define	SEEK_ABS	0
#define	SEEK_CUR	1
#define	SEEK_END	2

#define	BYTEDATA	1		/* 1 bytes of data		*/
#define	WORDDATA	2		/* 2 bytes of data		*/
#define	LONGDATA	4		/* 4 bytes of data		*/
#define	FLOATDATA	4		/* 4 bytes of data		*/
#define	DOUBLEDATA	8		/* 8 bytes of data		*/

/*======================================================================*/
/*	MACROS								*/
/*======================================================================*/

#define	ISKEYSEP(ch)		((ch) == ':'  || (ch) == ','  || (ch) == '='  || (ch) == '\"' )
#define WHITESPACE(ch)		((ch) == ' '  || (ch) == '\t' || (ch) == '\n' || (ch) == '\0' )
#define ISWHITESPACE(ch)	((ch) == ' '  || (ch) == '\t')
#define	ISEOL(ch)		((ch) == '\n' || (ch) == '\0')
#define ISWHITE(ch)		(((ch) == ' ' || (ch) == '\t') && !ISEOL((ch)))

/*======================================================================*/
/*	DATA TYPES							*/
/*======================================================================*/
typedef char		S8;
typedef unsigned char 	U8;
typedef char 		BYTE;
typedef unsigned char 	UBYTE;

typedef short		S16;
typedef unsigned short	U16;
typedef short 		WORD;
typedef unsigned short	UWORD;

typedef long		S32;
typedef unsigned long	U32;
typedef long		LONG;
typedef unsigned long	ULONG;

typedef unsigned char 	STRING;
typedef unsigned char 	BOOLEAN;

/*======================================================================*/
/*	                             EOF                                */
/*======================================================================*/

